/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;
import net.adventurez.entity.IguanaEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@Environment(value=EnvType.CLIENT)
public class IguanaModel<T extends IguanaEntity>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart cube_r1;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart left_middle;
    private final ModelPart left_front;
    private final ModelPart left_back;
    private final ModelPart right_middle;
    private final ModelPart right_front;
    private final ModelPart right_back;

    public IguanaModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.tail = this.body.m_171324_("tail");
        this.cube_r1 = this.tail.m_171324_("cube_r1");
        this.head = root.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.left_middle = root.m_171324_("left_middle");
        this.left_front = root.m_171324_("left_front");
        this.left_back = root.m_171324_("left_back");
        this.right_middle = root.m_171324_("right_middle");
        this.right_front = root.m_171324_("right_front");
        this.right_back = root.m_171324_("right_back");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition modelPartData1 = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.5f, -3.5f, -18.0f, 11.0f, 6.0f, 15.0f).m_171514_(0, 0).m_171481_(-5.5f, -3.5f, -18.0f, 11.0f, 6.0f, 15.0f).m_171514_(37, 0).m_171481_(-4.5f, -2.5f, -3.0f, 9.0f, 5.0f, 6.0f).m_171514_(0, 20).m_171481_(0.0f, -6.0f, -17.0f, 0.0f, 3.0f, 13.0f).m_171514_(0, 0).m_171481_(0.0f, -5.0f, -1.0f, 0.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)20.5f, (float)10.0f));
        PartDefinition modelPartData2 = modelPartData1.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)2.5f));
        modelPartData2.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(26, 23).m_171481_(-3.5f, -2.5f, -0.5f, 7.0f, 4.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartData3 = modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171481_(-4.5f, -3.5f, -8.5f, 9.0f, 3.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)21.5f, (float)-7.5f));
        modelPartData3.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171481_(-4.5f, -0.5f, -8.5f, 9.0f, 2.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("left_middle", CubeListBuilder.m_171558_().m_171514_(27, 37).m_171481_(-2.0f, -0.5f, -2.0f, 4.0f, 5.0f, 4.0f), PartPose.m_171419_((float)7.5f, (float)19.5f, (float)4.0f));
        modelPartData.m_171599_("left_front", CubeListBuilder.m_171558_().m_171514_(27, 37).m_171481_(-2.0f, -0.5f, -2.0f, 4.0f, 5.0f, 4.0f), PartPose.m_171419_((float)7.5f, (float)19.5f, (float)-5.0f));
        modelPartData.m_171599_("left_back", CubeListBuilder.m_171558_().m_171514_(27, 37).m_171481_(-2.0f, -0.5f, -2.0f, 4.0f, 5.0f, 4.0f), PartPose.m_171419_((float)6.5f, (float)19.5f, (float)10.0f));
        modelPartData.m_171599_("right_middle", CubeListBuilder.m_171558_().m_171514_(27, 37).m_171506_(-2.0f, -0.5f, -2.0f, 4.0f, 5.0f, 4.0f, true), PartPose.m_171419_((float)-7.5f, (float)19.5f, (float)4.0f));
        modelPartData.m_171599_("right_front", CubeListBuilder.m_171558_().m_171514_(27, 37).m_171506_(-2.0f, -0.5f, -2.0f, 4.0f, 5.0f, 4.0f, true), PartPose.m_171419_((float)-7.5f, (float)19.5f, (float)-5.0f));
        modelPartData.m_171599_("right_back", CubeListBuilder.m_171558_().m_171514_(27, 37).m_171506_(-2.0f, -0.5f, -2.0f, 4.0f, 5.0f, 4.0f, true), PartPose.m_171419_((float)-6.5f, (float)19.5f, (float)10.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)128, (int)128);
    }

    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.cube_r1.f_104203_ = -0.1745f;
        this.head.f_104203_ = headPitch * 0.007453292f;
        this.head.f_104204_ = headYaw * 0.0017453292f;
        this.right_back.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.left_back.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.right_front.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.left_front.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.right_middle.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + 4.712389f)) * 1.4f * limbDistance;
        this.left_middle.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + 1.5707964f)) * 1.4f * limbDistance;
        this.jaw.f_104203_ = (Boolean)entity.m_20088_().m_135370_(IguanaEntity.OPEN_MOUTH) != false ? 0.3f : 0.0f;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.left_middle, (Object)this.left_front, (Object)this.left_back, (Object)this.right_middle, (Object)this.right_front, (Object)this.right_back);
    }
}

